package com.ejie.ab04b.control;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.propertyeditors.CustomDateEditor;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.ejie.ab04b.constantes.Constantes;
import com.ejie.ab04b.model.VdesestimadosOs2;
import com.ejie.ab04b.service.VdesestimadosOs2Service;
import com.ejie.ab04b.util.seguridad.UtilSeguridad;
import com.ejie.x38.control.bind.annotation.RequestJsonBody;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;

/**
 * VdesestimadosOs2Controller generated by UDA, 04-ago-2017 12:51:38.
 * 
 * @author UDA
 */

@Controller()
@RequestMapping(value = "/vdesestimadosos2")
public class VdesestimadosOs2Controller {

	private static final Logger logger = LoggerFactory
			.getLogger(VdesestimadosOs2Controller.class);

	public static final String ATTR_NAME_DESESOS2_FILTER = "vdesestimientoOs2FiltroModel";

	@Autowired()
	private VdesestimadosOs2Service vdesestimadosOs2Service;

	/**
	 * Usamos este mÃ©todo para indicarle a Spring el formato que debe usar para
	 * serializar las fechas cuando cargamos la entidad en el Model. En el resto
	 * de peticiones que devuelven un objeto con la anotaciÃ³n '@ResponseBody'
	 * se usan los serializadores de UDA
	 * 
	 *  binder
	 *            WebDataBinder
	 *
	 * @param binder the binder
	 */
	@InitBinder()
	public void initBinder(WebDataBinder binder) {

		Locale locale = LocaleContextHolder.getLocale();
		DateFormat dateFormat = null;
		if (locale.equals(Constantes.LOCALE_ES)) {
			dateFormat = new SimpleDateFormat(Constantes.ES_DATE_MASK);
		} else {
			dateFormat = new SimpleDateFormat(Constantes.EU_DATE_MASK);
		}
		binder.registerCustomEditor(Date.class,
				new CustomDateEditor(dateFormat, true));
	}

	/**
	 * Metodo de presentacion del RUP_TABLE.
	 * 
	 *  model
	 *            Model
	 *
	 * @param model the model
	 *  String
	 * @return the form edit
	 */
	@RequestMapping(method = RequestMethod.GET)
	public String getFormEdit(Model model) {
		VdesestimadosOs2Controller.logger
				.info("[GET - View] : vdesestimadosos2");

		// Combos del Filtro
		this.precargaCombosFiltroBusqueda(model);

		return "vdesestimadosos2";
	}

	/**
	 * Operacion de filtrado del componente RUP_TABLE.
	 * 
	 *  filterVdesestimadosOs2
	 *            VdesestimadosOs2 Bean que contiene los parametros de filtrado
	 *            a emplear.
	 *  jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 *
	 * @param filterVdesestimadosOs2 the filter vdesestimados os 2
	 * @param jqGridRequestDto the jq grid request dto
	 *  JQGridResponseDto<VdesestimadosOs2> Dto que contiene el resultado
	 *         del filtrado realizado por el componente RUP_TABLE.
	 * @return the JQ grid response dto
	 */
	@RequestMapping(value = "/filter", method = RequestMethod.POST)
	public @ResponseBody JQGridResponseDto<VdesestimadosOs2> filter(
			@RequestJsonBody(param = "filter") VdesestimadosOs2 filterVdesestimadosOs2,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		VdesestimadosOs2Controller.logger
				.info("[POST - filter] : Obtener VdesestimadosOs2s");
		return this.vdesestimadosOs2Service.filter(filterVdesestimadosOs2,
				jqGridRequestDto, false);
	}

	/**
	 * AÃ±ade al model los datos necesarios para la carga de los combos de la
	 * pantalla del filtro de busqueda.
	 * 
	 *  model            Model
	 *
	 * @param model the model
	 */
	private void precargaCombosFiltroBusqueda(Model model) {

		model.addAttribute("autoridades",
				UtilSeguridad.getInstance().obtenerDelegacionesUsuario());

		VdesestimadosOs2 desestimiento = new VdesestimadosOs2();

		Calendar c = Calendar.getInstance();
		desestimiento.setAnoExp(String.valueOf(c.get(Calendar.YEAR)));

		model.addAttribute(VdesestimadosOs2Controller.ATTR_NAME_DESESOS2_FILTER,
				desestimiento);
	}

}
